---
releasedAt: 2025-10-02T00:00:00.000Z
writtenAt: 2025-10-02T00:00:00.000Z
---

안녕하세요, 파트너 정산 자동화 팀입니다.

파트너 정산 자동화 제품의 테스트 환경 확장에 따른 API 변경 사항을 안내드립니다.

---

## \[파트너 정산 자동화] 테스트 환경 분리 및 API 변경 사전 안내

이번 업데이트로 운영 환경과 테스트 환경이 완전히 분리되어, 설정·정산 정책·내역서 템플릿 등을 독립적으로 관리하실 수 있습니다.

## 주요 변경 사항

- 신규 쿼리 파라미터: test: Boolean (선택값)

- 적용 대상: 모든 파트너 정산 REST API

- 적용 예정 일자: 2025년 11월 중 (정확한 일자는 추후 별도 안내 예정)

- 기본값: false

- 연동 환경 별 설정
  - 라이브: 하위호환성이 보장되어 영향이 없습니다.
  - 테스트: test=true 쿼리 파라미터 추가 설정이 필요합니다.

(이미지 첨부: as is - to be)

이번 변경으로 라이브/테스트 환경이 완전히 분리되어 더욱 자유로운 테스트가 가능해집니다.\
_기존 데이터는 테스트 및 라이브 환경에 복제되어 기존 그대로 활용하실 수 있습니다._

---

## 개선 사항

### 1. 정산 정책 및 수식 테스트 환경 분리

기존에는 정산 정책 및 정산 수식을 변경할 때 별도의 테스트 환경이 없어 운영에 영향을 줄 우려가 있었습니다.\
이번 개선으로 라이브 환경과 완전히 분리된 테스트 환경을 제공하여, 정산 정책 및 수식을 실제 운영에 영향 없이 안전하게 테스트할 수 있습니다.

### 2. 파트너 데이터 환경 분리

테스트를 위해 등록한 파트너가 라이브 데이터에 그대로 남아 실제 파트너와 함께 조회되는 불편함이 있었습니다.\
테스트용 파트너는 테스트 환경에 별도로 등록하여, 실제 파트너 데이터와 분리하여 관리할 수 있습니다.

### 3. 국세청 연동 환경 분리

국세청 연동 시 라이브와 테스트 환경에 동시에 연동되어 불필요한 연동 안내 메일을 중복으로 받는 문제가 있었습니다.\
환경별로 독립적인 국세청 연동이 가능해져 필요한 환경에서만 선택적으로 연동할 수 있습니다.

---

## 세부 변경 사항

### 1. 기존 요청 본문에서 테스트 환경 구분이 가능한 API

요청 본문(body)의 `isForTest` 파라미터로 환경을 지정하던 방식은 deprecated 되었습니다.\
쿼리 파라미터 `test`로 대체 해 주시기 바랍니다. deprecated 필드는 2026년 이후 별도 공지와 함께 지원이 중단될 예정입니다.

```http
#Query Parameter가 우선 적용
POST /platform/transfers/order?test=true
{
  "isForTest": false,  // 무시됨, Query Parameter의 true가 적용
  ...
}

#Query Parameter 가 없으면 Request Body 값 사용
POST /platform/transfers/order
{
  "isForTest": true,  // 이 값이 적용
  ...
}
```

우선순위는 아래와 같습니다.

1. Query Parameter 의미 `test` (최우선)
2. Request Body 의 `isForTest` (Query Parameter 없을 때)
3. 기본값 `false` (둘 다 없을 때)

영향 받는 API는 다음과 같습니다.

- 정산 상세 내역 다운로드 `GET /platform/transfer-summaries/sheet-file`
- 정산건 다건 조회 `GET /platform/transfer-summaries`
- 수기 정산건 생성 `POST /platform/transfers/manual`
- 주문 정산건 생성 `POST /platform/transfers/order`
- 주문 취소 정산건 생성 `POST /platform/transfers/order-cancel`
- 정산 내역 다건 조회 `GET /platform/partner-settlements`
- 지급 내역 다건 조회 `GET /platform/payouts`
- 일괄 지급 내역 다건 조회 `GET /platform/bulk-payouts`
- 이체 내역 다건 조회 `GET /platform/account-transfers`
- 일괄 이체 내역 다건 조회 `GET /platform/bulk-account-transfers`

### 2. 테스트 환경 지정이 필요한 API

테스트 환경 지정을 위해 쿼리 파라미터 `test`가 추가되었습니다.\
해당 파라미터는 선택 값이며 기본값은 `false`입니다.

```http
#라이브 환경 데이터만 조회 (기본값)
GET /platform/transfers/{id}

#테스트 환경 데이터만 조회
GET /platform/transfers/{id}?test=true
```

영향 받는 API는 다음과 같습니다.

- 정산건 조회 `GET /platform/transfers/{id}`
- 정산건 삭제 `DELETE /platform/transfers/{id}`
- 추가 수수료 정책 다건 조회 `GET /platform/additional-fee-policies`
- 추가 수수료 정책 생성 `POST /platform/additional-fee-policies`
- 추가 수수료 정책 조회 `GET /platform/additional-fee-policies/{id}`
- 추가 수수료 정책 수정 `PATCH /platform/additional-fee-policies/{id}`
- 추가 수수료 정책 보관 `POST /platform/additional-fee-policies/{id}/archive`
- 추가 수수료 정책 복원 `POST /platform/additional-fee-policies/{id}/recover`
- 계약 다건 조회 `GET /platform/contracts`
- 계약 생성 `POST /platform/contracts`
- 계약 조회 `GET /platform/contracts/{id}`
- 계약 수정 `PATCH /platform/contracts/{id}`
- 계약 보관 `POST /platform/contracts/{id}/archive`
- 계약 복원 `POST /platform/contracts/{id}/recover`
- 할인 분담 정책 다건 조회 `GET /platform/discount-share-policies`
- 할인 분담 정책 생성 `POST /platform/discount-share-policies`
- 할인 분담 정책 조회 `GET /platform/discount-share-policies/{id}`
- 할인 분담 정책 수정 `PATCH /platform/discount-share-policies/{id}`
- 할인 분담 정책 보관 `POST /platform/discount-share-policies/{id}/archive`
- 할인 분담 정책 복원 `POST /platform/discount-share-policies/{id}/recover`
- 파트너 다건 조회 `GET /platform/partners`
- 파트너 생성 `POST /platform/partners`
- 파트너 다건 생성 `POST /platform/partners/batch`
- 파트너 일괄 국세청 연동 `POST /platform/partners/member-company-connect`
- 파트너 국세청 연동 `POST /platform/partners/member-company-connect/{id}`
- 파트너 일괄 국세청 연동 해제 `POST /platform/partners/member-company-disconnect`
- 파트너 국세청 연동 해제 `POST /platform/partners/member-company-disconnect/{id}`
- 파트너 조회 `GET /platform/partners/{id}`
- 파트너 수정 `PATCH /platform/partners/{id}`
- 파트너 보관 `POST /platform/partners/{id}/archive`
- 파트너 복원 `POST /platform/partners/{id}/recover`
- 예금주 조회 `GET /platform/bank-accounts/{bank}/{accountNumber}/holder`
- 사업자 조회 `GET /platform/companies/{businessRegistrationNumber}/state`

---

작성일자: **2025년 10월 02일**

- 일반 문의: <cs@portone.io> / 채널톡
- 기술지원 문의: <support.b2b@portone.io> / 파트너스 슬랙 채널
