---
title: 연동 유의사항
description: 웰컴페이먼츠 연동 유의사항을 소개합니다.
targetVersions:
  - v1
---

## 웰컴페이먼츠와 사전 계약이 필요한 경우

아래 기능을 사용하시려면 웰컴페이먼츠에 사전 신청 후 계약이 완료되어야 합니다. 그렇지 않은 상태에서
해당 기능 이용시 결제 승인에 실패하거나, 승인에 성공하더라도 의도한 바와는 다른 응답(예: 결제창에서
에스크로 결제를 했으나 비-에스크로 결제 응답을 받음)을 얻게 될 수 있으니 주의 해주시기 바랍니다.

- 간편결제 사용
- 면세 / 복합과세 / 지정금액 방식 사용
- 할부 사용
- 상점 부담 무이자 할부 사용
- 카드사 포인트 사용
- 에스크로 사용
- 휴대폰 실물 / 컨텐츠 사용
- 휴대폰 빌링키 발급과 동시에 결제 실물 / 컨텐츠 사용

## 테스트 모드 유의사항

### 테스트 모드에서 확인 불가능한 일부 기능/파라미터 존재

- 일부 간편결제(LPAY, 페이코) 결제 테스트 불가능
- 카드사 포인트 사용(useCardPoint 파라미터) 테스트 불가능
- 계좌이체 뱅크페이 QR 코드 결제 불가능

### 실제 카드사와 통신을 하지 않기 때문에 결제창 호출시 전달 한 결제 정보 그대로 승인 결과가 내려감

예를 들어 체크 카드는 할부 결제가 불가능하기 때문에, 운영 환경에서는 할부 파라미터를 설정 후 실제 카드사 앱에서 체크 카드로 결제시 승인에 실패합니다.

하지만 테스트 환경의 경우, 할부 파라미터를 설정 후 실제 카드사 앱에서 체크 카드로 결제해도 승인에
성공하며, 승인 결과로 할부 개월수는 0(일시불)이 아닌, 결제창 호출시 전달 한 값 그대로 리턴됩니다.

<details>

<summary>파라미터 예제 코드</summary>

1. 국민카드 5개월 할부 다이렉트 호출

   ```json
   {
     "channelKey": "{콘솔 내 연동 정보의 채널키}",
     "pay_method": "card",
     "amount": "50000",
     "card": {
       "direct": {
         // 국민카드 5개월 할부 다이렉트 호출
         "code": "381",
         "quota": 5
       }
     }
   }
   ```

2. 국민카드 앱에서 체크카드로 결제

3. 승인 응답 결과 할부 개월수가 5로 전달 됨

   ```json
   // GET /payments/{imp_uid}
   {
     "card_quota": 5
   }
   ```

</details>

## 공통 유의사항

### 구매자 연락처(PC만), 이름, 주문명, 주문번호는 필수 입력

웰컴페이먼츠의 경우 구매자 연락처(PC만), 이름, 주문명 그리고 주문번호는 필수 입력입니다.

### IOS 앱 결제시 고객사 커스텀 앱 URL 스킴 파라미터(`app_scheme`)는 필수 입력

IOS 앱 결제시, 고객사 커스텀 앱 URL 스킴 파라미터(예) `portone://`)는 필수로 입력하셔야 합니다.

단, **반드시 모바일 앱일때만 입력**하셔야 하며 모바일 웹일때 입력하실 경우, 정상적으로 동작하지 않을 수 있으니 유의하시기 바랍니다.

### IOS에서 서드 파티 앱에서 인증 후 수동으로 복귀해야 함

IOS 모바일 웹/인앱 브라우저에서 결제창 호출 후 카드사 앱으로 이동해 인증을 완료한 경우, 다시 브라우저로 복귀하기 위해서는 수동으로 이동해주셔야 합니다.

### 현금영수증 옵션은 자진 발급만 지원

웰컴페이먼츠 가상계좌 발급, 계좌이체와 같은 현금성 결제시 현금영수증 옵션을 전달할 수 있습니다.

단, 현금영수증 자진발급(`anonymous`) 옵션만 지원하기 때문에 현금영수증 발행 식별 정보 파라미터(`customerIdentifier`)는 지원하지 않습니다.

<details>

<summary>지원 가능: 현금영수증 자진 발급</summary>

```json
{
  // 현금영수증 자진 발급
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "vbank",
  "bypass": {
    "cashReceiptType": "anonymous"
  }
}
```

</details>

<details>

<summary>지원 불가: 현금영수증 소득공제/지출증빙</summary>

```json
// 현금영수증 소득공제
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "trans",
  "bypass": {
    "cashReceiptType": "personal",
    "customerIdentifier": "01012345678"
  }
}
// 웰컴페이먼츠에서 제공하지 않는 현금영수증 발급 유형(CASH_RECEIPT_TYPE_PERSONAL)입니다.
```

```json
// 현금영수증 지출증빙
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "trans",
  "bypass": {
    "cashReceiptType": "corporate",
    "customerIdentifier": "1178178260"
  }
}
// 웰컴페이먼츠에서 제공하지 않는 현금영수증 발급 유형(CASH_RECEIPT_TYPE_CORPORATE)입니다.
```

</details>

## 제공기간 파라미터(`period`)

### 날짜(`from`과 `to`)와 간격(`interval`) 둘 중 하나만 사용 가능

제공기간 파라미터는 (from과 to) 또는 interval만 입력 가능하며 셋 다 입력은 불가능합니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// period: { from: "2023-01-01", to: "2023-03-01", interval: "1m" }
{
  "error_msg": "제공 기간은 range와 interval 둘 중 하나만 입력해주세요"
}
```

</details>

또한 from과 to를 입력하는 경우 둘 다 입력해야하며 둘 중 하나만 입력은 불가능합니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// period: { from: "2023-01-01" }
{
  "error_msg": "웰컴페이먼츠의 경우 제공 기간은 시작 날짜와 종료 날짜를 모두 입력하셔야 합니다. (둘 중 하나만 입력 불가)"
}
```

```json
// period: { to: "2023-03-01" }
{
  "error_msg": "웰컴페이먼츠의 경우 제공 기간은 시작 날짜와 종료 날짜를 모두 입력하셔야 합니다. (둘 중 하나만 입력 불가)"
}
```

</details>

### 날짜(`from`과 `to`)의 경우 PC와 모바일 지원 형식이 다름

웰컴페이먼츠의 경우 제공기간 파라미터에 대해 PC의 경우 날짜까지만 표기되지만 모바일의 경우 분까지 표기됩니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
{
  "period": { "from": "2023-01-01 00:00:00", "to": "2023-03-01 23:59:59" }
}
// PC에서는 "2023-01-01 ~ 2023-03-01"로 표기(시간 정보 무시)
// 모바일에서는 "2023-01-01 00:00 ~ 2023-03-01 23:59"로 표기(초 정보 무시)
```

</details>

### 간격(`interval`)은 1m 또는 1y만 허용 됨

웰컴페이먼츠의 경우 제공 기간을 간격으로 입력하는 경우, 1m 또는 1y만 허용됩니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 옵션1. interval을 1m로 설정
{
  "period": { "interval": "1m" }
}
```

```json
// 옵션2. interval을 1y로 설정
{
  "period": { "interval": "1y" }
}
```

```json
// 옵션 3. interval을 1d로 설정
{
  "period": { "interval": "1d" }
}
// -> 웰컴페이먼츠 제공 기간 주기가 올바르지 않습니다. 1m 또는 1y만 허용됩니다.
```

</details>

### 모바일 환경 - 휴대폰 결제시 제공 기간 파라미터(`period`)를 지원하지 않음

모바일 환경에서는 휴대폰 결제 / 빌링키 발급과 동시에 결제시 제공 기간 파라미터(`period`)를 지원하지 않습니다.

## 휴대폰 일반 결제/빌링키 발급과 동시에 결제

### 상품 유형 파라미터(`digital`)는 필수 입력

웰컴페이먼츠의 경우 **휴대폰 소액결제시 상품 유형을 구분 짓는 `digital` 파라미터가 필수**로 요구됩니다.
상품 유형이 디지털 컨텐츠인 경우 `true`를, 실물인 경우엔 `false`를 전달합니다.

### 렌더링을 허용 할 통신사 리스트 옵션과 기본 선택 될 통신사 옵션은 함께 사용할 수 없음

렌더링을 허용 할 통신사 리스트(`phone.detail`) 옵션과 기본 선택 될 통신사 옵션(`bypass.welcome.acceptmethod.hppdefaultcorp(통신사)`/`P_RESERVED.hpp_default_corp=통신사`)은 함께 사용할 경우 정상적으로 동작하지 않아 둘 중 하나만 사용해야 합니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 옵션1. SKT와 KT만 렌더링을 허용 -> 정상 동작
{
  "phone": {
    "detail": [
      { "carrier": "SKT", "enabled": true },
      { "carrier": "KTF", "enabled": true }
    ]
  }
}
```

```json
// 옵션2. SKT를 기본 선택 -> 정상 동작
{
  "bypass": {
    "welcome": {
      "acceptmethod": ["hppdefaultcorp(SKT)"],
      "P_RESERVED": ["hpp_default_corp=SKT"]
    }
  }
}
```

```json
// 옵션3. 옵션 1 + 옵션 2 -> 정상 동작하지 않음
{
  "phone": {
    "detail": [
      { "carrier": "SKT", "enabled": true },
      { "carrier": "KTF", "enabled": true }
    ]
  },
  "bypass": {
    "welcome": {
      "acceptmethod": ["hppdefaultcorp(SKT)"],
      "P_RESERVED": ["hpp_default_corp=SKT"]
    }
  }
}
```

</details>

## 일반결제 유의사항

### 카드 결제

#### PC 환경에서는 할부 개월수에 일시불이 기본 포함 됨

웰컴페이먼츠의 경우 PC 환경에서는 일시불이 기본으로 포함되기 때문에, 할부 개월수에 0(일시불)을 넣지 않더라도 결제창에 자동으로 표기됩니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card",
  "display": {
    "card_quota": [2, 3, 4, 5, 6] // 일시불 + 2개월 ~ 6개월까지 결제창에 표기
  }
}
```

</details>

#### PC 환경에서는 할부 옵션을 설정하지 않는 경우 무조건 일시불로 결제 됨

웰컴페이먼츠의 경우 PC 환경에서 \*\*할부 옵션을 전달하지 않는 경우 `무조건 일시불만 표기`\*\*되니 주의하시기 바랍니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 일시불만 표기
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card"
}
```

```json
// 일시불 + 2개월 ~ 6개월까지 결제창에 표기
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card",
  "display": {
    "card_quota": [2, 3, 4, 5, 6] // 일시불 + 2개월 ~ 6개월까지 결제창에 표기
  }
}
```

</details>

#### 카드사 다이렉트 호출시 고정 할부 개월수는 필수 입력

웰컴페이먼츠의 경우 **카드사 다이렉트 호출시 고정 할부 개월수는 필수 입력**입니다.
따라서 카드사 다이렉트 호출시 리스트 할부 개월수는 입력할 수 없습니다.

예를 들어, BC카드 다이렉트 호출을 하고 싶은 경우 다른 PG사는 `card: { direct: { code: '361' } }`만
지정하면 되지만 웰컴페이먼츠의 경우 카드사 다이렉트 호출시 고정 할부 개월수는 필수 입력이기 때문에
할부 개월수를 함께 넘겨야 하니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 예. BC카드 5개월 할부
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card",
  "card": {
    "direct": {
      // 다이렉트 호출 할 카드사 코드와 고정 할부 개월수를 모두 지정해야 함
      "code": "361", // BC카드
      "quota": 5 // 5개월 할부
    }
  }
}
```

```json
// 예. 결제창에서 카드사와 할부 개월수 선택
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card"
}

// 다이렉트 호출 할 카드사와 고정 할부 개월수 모두 지정하지 않아야 함
```

</details>

#### 카드사 포인트 사용 불가 옵션 사용 불가능

웰컴 페이먼츠에서 카드사 포인트 사용 불가 옵션(useCardPoint: false)은 지원하지 않기 때문에 카드사
포인트 사용(useCardPoint: true) 또는 기본값(=파라미터 전달하지 않음, 결제창에서 고객이 카드사 포인트
사용 여부 결정)만 사용 가능합니다.

카드사 포인트 사용 불가 옵션 설정시 “결제 창 호출에 실패하였습니다. 웰컴페이먼츠의 경우 카드사
포인트 사용 불가 옵션은 사용할 수 없습니다.”라는 에러 메시지가 리턴되면서 결제창이 호출되지 않으니
참고 부탁드립니다.

#### 카카오뱅크 카드는 일시불만 지원함

카카오뱅크 카드로 결제시 결제 금액이 5만원 이상이라고 하더라도 할부가 불가능하기 때문에 무조건 일시불로 결제됩니다.

#### ISP 계열 카드의 경우 할부 개월수에 무이자 표기 되지 않음

ISP 계열 카드의 경우, 결제 요청시 페이북 팝업/앱으로 넘어가는데 무이자 할부 적용 조건이 되더라도 할부 개월수 리스트에 (무) 표기가 되지 않습니다.

단, 해당 카드사, 결제 금액, 할부 개월수가 무이자 조건을 만족하는 경우 승인시 무이자가 자동 적용됩니다.

#### 모바일 환경에서 고정/리스트 할부 개월수 최대 값은 36

모바일 환경에서 웰컴페이먼츠 카드 결제시, 고정/리스트할부 개월수 최대 값은 36으로 37 이상의 값을 입력할 경우 결제창이 호출되지 않으니 참고하시기 바랍니다.

PC 환경에서는 별도 제한이 없습니다.

### 가상계좌 발급

#### `vbank_due` 파라미터는 "분" 까지만 유효하며 시간 값은 무시 됨

가상계좌 발급시 입금 기한을 의미하는 `vbank_due` 파라미터는 아래 4가지 형식 중 하나로 입력이 가능합니다.

- YYYYMMDD
- YYYYMMDDHHmmss
- YYYY-MM-DD
- YYYY-MM-DD HH:mm:ss

단, 웰컴페이먼츠의 경우 전달 한 초 값은 무시되며 무조건 59초로 설정되니 유의하시기 바랍니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
{
  "vbank_due": "2023-01-01 12:34:56"
}
// 입금 기한이 "2023-01-01 12:34:59"로 설정 됨
```

</details>

### 상품권 결제

#### 문화 상품권(culturegift)만 지원

웰컴페이먼츠의 경우 상품권 결제시 문화상품권만 지원하며 북앤라이프, 컬쳐랜드 그리고 스마트 문상은 지원하지 않습니다.

### 간편 결제

#### 토스페이의 경우, 할부 개월수 리스트는 전달한 값과 카드사가 제공하는 무이자 할부 개월 수의 최대값까지 표기 됨

예를 들어 할부 개월수 리스트를 3개월까지 렌더링 되도록 설정했으나, 현재 해당 카드사에서 6개월까지 무이자 할부 이벤트가 진행되고 있다면 할부 개월수는 6개월까지 표기 됩니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 예) 할부 개월수를 3개월까지 렌더링 되도록 설정
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card",
  "display": {
    "card_quota": [2, 3]
  }
}

// 결과) 테스트 당시 우리카드가 6개월까지 무이자 할부 이벤트가 진행중이기 때문에 6개월까지 할부 개월수가 렌더링 됨
```

</details>

#### 카카오페이의 경우, 카드 정보를 제공하지 않음

카카오페이에 등록 된 카드로 결제시 카카오페이에서 카드 정보를 내려주지 않기 때문에 카드 정보를 확인할 수 없습니다.

## 빌링키 발급 유의사항

### 빌링키 발급 수단(`pay_method`)은 필수 입력이며 카드(`card`)만 허용 됨

웰컴페이먼츠의 경우 빌링키 발급 수단은 카드만 허용되며, 휴대폰의 경우 빌링키 발급과 동시에 결제만 가능합니다.

### 실제 승인이 되지 않고 빌링키 발급만 됨

금액(amount) 파라미터는 필수 입력이며, **전달 한 금액(amount)만큼 실제로 승인이 되지 않고** 단순히 빌링키 발급 창에 표기 될 용도로만 사용됩니다.

### 면세 금액(tax\_free)과 부가세(vat\_amount)는 지원하지 않음

빌링키 발급만 되고 실제 승인은 되지 않기 때문에 면세 금액과 부가세는 지원하지 않으며, 전달해도 무시됩니다.

## 빌링키 발급과 동시에 결제 유의사항

### 빌링키 발급 및 결제 수단(`pay_method`)은 필수 입력이며 휴대폰(`phone`)만 허용 됨

웰컴페이먼츠의 경우 빌링키 발급 및 결제 수단은 휴대폰만 허용되며, 카드의 경우 빌링키 발급만 가능합니다.

### 실제 승인이 됨

금액(amount) 파라미터는 필수 입력이며, **전달 한 금액(amount)만큼 실제로 승인이 됩니다.**

### 면세 금액(tax\_free)과 부가세(vat\_amount)는 지원하지 않음

웰컴페이먼츠의 경우 빌링키 발급과 동시에 결제시, 실제 승인이 되지만 면세 금액과 부가세는 지원하지 않으며, 전달해도 무시됩니다.

### 제공기간 파라미터(`phone`)는 지원하지 않으며 무조건 “월 자동결제”로 표기 됨

웰컴페이먼츠 빌링키 발급 및 결제는 휴대폰만 허용하고 휴대폰의 경우 통신사 정책에 의해 무조건 매월 자동결제만 허용됩니다.

따라서 제공기간 파라미터는 지원되지 않으며, PG 창의 제공기간 영역에 무조건 "월 자동결제"로 표기됩니다.

## 에스크로 유의사항

### 에스크로 결제의 경우 고객사가 임의로 취소할 수 없음

에스크로 결제건의 경우에는 기본적으로 구매자가 구매거절을 하지 않으면 고객사가 임의로 거래를 취소할 수 없습니다.

만약 에스크로 구매동의와 관계없이 고객사가 거래를 취소할 수 있도록 설정하고 싶은 경우에는 웰컴페이먼츠와 별도로 협의가 필요합니다.
