---
title: 연동 주의사항
description: KSNET 연동 시 주의사항을 확인할 수 있습니다.
targetVersions:
  - v1
---

<details>

<summary>계약 확인사항</summary>

**포트원을 통한 KSNET 이용 고객사의 상점아이디 과세 설정은 반드시 `복합과세`로 설정되어 있어야 합니다. 일반과세, 면세 설정은 지원하지 않습니다.**

- 키인결제

- 고객사 부담 무이자 할부 설정

- 가상계좌 마감일시 지정

- 가상계좌 환불

- 간편결제 사용

- 할부 사용

- 에스크로 사용, 배송 에스크로만 지원
  - KSNET에서 일반 에스크로, 배송 에스크로 두 가지 유형의 에스크로를 제공합니다. 포트원을 통해 KSNET 에스크로를 사용하려는 경우 반드시 **배송 에스크로** 설정이 되어 있어야 합니다.

- 휴대폰 결제 시 상품 유형 설정(실물 혹은 디지털)

</details>

<details>

<summary>특정카드사 고객사 부담 무이자 할부 설정 불가</summary>

KSNET에서 고객사 부담 무이자 할부 설정에 필요한 카드 코드 정보를 일부 카드사에 대해서만 제공하고 있습니다. 카드코드가 제공되지 않는 일부 카드사의 경우 고객사 부담 무이자 할부를 설정할 수 없습니다.

</details>

<details>

<summary>계좌이체 </summary>

## 결제창에서 현금영수증 발급 시 사업자번호, 휴대폰 번호에 숫자만 입력해야합니다.

계좌이체 결제창을 통한 현금영수증 발급 시 휴대폰번호, 사업자 번호는 **숫자만** 입력해야 합니다. 하이픈(-)을 포함한 다른 문자가 포함되는 경우 별다른 에러 표시 없이 결제는 진행되지만 현금영수증이 발급되지 않습니다.

</details>

<details>

<summary>가상계좌</summary>

## 예금주명 지정 불가

가상계좌의 예금주명은 고객사명으로 고정되며 별도 지정이 불가합니다.

## 부가세, 면세 금액 설정 지원 안 함

KSNET는 일회성 가상계좌의 경우 부가세, 면세 금액 설정을 지원하지 않습니다.

## 가상계좌 입금기한은 필수 입력 항목

KSNET에서 가상계좌 입금기한은 선택 입력 항목으로 안내하고 있지만 입력하지 않을 경우 가상계좌 입금기한을 특정할 수 없고 오동작할 가능성이 있어 필수로 입력해야합니다. (포트원에서는 필수 값으로 제한하고 있습니다.)

## 가상계좌 입금기한은 **초 단위 UNIX TIMESTAMP 사용**

`vbank_due` 파라미터로 전달하는 가상계좌 입금기한은 초 단위의 UNIX TIMESTAMP(통상 10자리 자연수)로 입력하여야 합니다. (`api로 가상계좌를 발급하는 경우에만 해당합니다.`)

</details>

<details>

<summary>에스크로 서비스</summary>

## 주문자 이메일 필수 입력

구매 확인을 받기 위한 주문자 이메일을 필수로 입력하여야 합니다.

## 등록 소요 시간 존재

에스크로 거래는 30분 \~ 1시간 뒤 [ksta.ksnet.co.kr](http://ksta.ksnet.co.kr/) > PG 거래내역 > 배송 에스크로 거래조회에서 확인이 가능합니다. 에스크로 정보 수정의 경우도 등록이 완료된 이후부터 가능합니다.

## 배송정보 발송일시는 **초 단위 UNIX TIMESTAMP 사용**

`logis.sent_at` 파라미터로 전달하는 배송정보 발송일시는 초 단위의 UNIX TIMESTAMP(통상 10자리 자연수)로 입력하여야 합니다.

</details>

<details>

<summary>키인결제</summary>

판매 상품에 대한 구분값으로 **`product_type`** 파라미터를 사용해야 결제가 가능합니다.

고객사 부담 무이자를 원하시는 경우 PG사와의 별도의 계약 후 **`interest_free_by_merchant`** 파라미터를 사용해야 합니다.

카드번호와 유효기간만으로 결제를 요청하는 비인증 승인 API만 연동되어 있어

**`birth`**(생년월일 6자리 혹은 사업자 등록번호 10자리)와 **`pwd_2digit`**(비밀번호 앞 2자리)는 검증하지 않습니다.

</details>

<details>

<summary>빌링키 결제</summary>

판매 상품에 대한 구분값으로 **`product_type`** 을 파라미터로 사용해야 결제가 가능합니다.

고객사 부담 무이자를 원하시는 경우 pg 사와의 별도의 계약 후 **`interest_free_by_merchant`** 파라미터를 사용해야 합니다.

</details>

<details>

<summary>빌링키 등록</summary>

`card_number`, `expiry`, `pwd_2digit`, `birth` 파라미터 입력은 필수 입니다.

</details>

<details>

<summary>기타</summary>

- 휴대폰 결제는 부분취소 불가능.

- 카드, 간편결제 외 결제의 경우 매출 전표 확인 불가능.

- 간편결제(카카오페이, 페이코) 카드 결제의 경우 KSNET 측에서 카드정보(카드번호, bin) 정보를 제공해주지 않아 결제 정보에 카드사 정보가 제공되지 않습니다.

- USD 결제는 순수 해외카드로만 결제 가능합니다.

- 카카오페이 사용 시 상점정보(대표자명, 주소, 전화번호)를 필수로 입력해야합니다

- 부분취소는 총 9회까지 가능합니다. (카드결제, 가상계좌, 계좌이체, 간편결제)

- 취소는 결제일 기준 6개월 이내에만 가능합니다.

- 가상계좌 환불은 23:00\~06:00 시간 외에만 가능합니다.

- 계좌입금 거래 시 결제창에서 발급한 현금영수증은 경우 거래 취소 시 자동으로 취소 되지 않습니다.

- 복합과세의 계좌입금 거래를 부분취소하는 경우 기존에 발급한 현금영수증을 취소하고 부분취소 금액이 반영된 금액 정보로 다시 현금영수증을 발급해야합니다.

- 매출 전표 확인 시 자동으로 인쇄 기능이 호출됩니다. 오동작이 아닌 KSNET의 의도된 기능입니다.

- 간편 결제 수단에서 고객사 부담 무이자 설정은 사용 불가능합니다.

- 간편 결제 수단에서 할부 개월 수 표시 설정은 일부 간편결제사에서만 가능합니다.
  - 네이버페이, 카카오페이, LPay: 할부 개월 수 표시 설정 가능
  - Payco, SSGPay: 할부 개월 수 표시 설정 불가, 5만원 이상 시 1\~12 개월 표시 고정

</details>

<div class="hint" data-style="danger">

특이사항

- 카드, 간편결제를 외 결제 수단 에서는 매출전표를 제공하지 않습니다.
- KSNET은 KRW, USD 만 지원합니다.
- USD 결제의 경우 순수 해외 카드만 결제 가능합니다.
- 페이코, 카카오페이의 경우 카드번호 혹은 카드bin 정보를 제공하지 않습니다.
- 주문자 이메일(`buyer_email`)은 선택 입력 항목이지만 에스크로 결제에서 구매확인 이메일 수신을 위해 필수로 입력해야 합니다.
- 발급사가 비씨,국민,하나,삼성,신한,현대,롯데,농협인 경우에 `고객사 무이자 할부`를 설정할 수 있습니다.
- 결제 취소 시 부분취소는 9회까지 가능합니다. (카드결제, 가상계좌, 계좌이체)
- 취소는 결제일 기준으로 6개월까지만 가능합니다.
- 가상계좌 환불은 23:00\~06:00 시간 외에만 가능합니다.
- 가상계좌 환불은 특약이 있는 고객사만 사용 가능합니다.
- 휴대폰 결제는 부분취소를 지원하지 않습니다.
- 계좌입금 거래 시 발급한 현금영수증은 경우 거래 취소 시 자동으로 취소 되지 않습니다. 수동으로 취소해야 합니다.
- **포트원을 통한 KSNET 이용 고객사의 상점아이디의 과세설정은 `복합과세`만 지원합니다.**

</div>
